create table plan_generator (
  pg_id    int         not null,
  pg_char  char        not null,
  pg_name  varchar(30) not null,
  primary key (pg_id),
  unique(pg_char),
  unique(pg_name)
);

create table card_provider (
  cp_id    int         not null,
  cp_name  varchar(30) not null,
  primary key (cp_id),
  unique(cp_name)
);

create table build_plan_class (
  bpc_id    int         not null,
  bpc_name  varchar(30) not null,
  primary key (bpc_id),
  unique (bpc_name)
);

create table build_plan_instance (
  bpi_id             int         not null,
  bpi_bpc            int         not null,
  bpi_cf_join_bundle int         not null,
  bpi_cf_mat         int,
  bpi_cf_concat      int,
  primary key (bpi_id),
  foreign key (bpi_bpc) references build_plan_class (bpc_id)
);

create table join_impl (
  ji_id          int         not null,
  ji_kind        int         not null,
  ji_flag_left   int         not null,
  ji_flag_right  int         not null,
  ji_name        varchar(20) not null,
  primary key (ji_id)
);

create table sch_relation (
  sr_id    int         not null,
  sr_name  varchar(30) not null,
  sr_card  BIGINT      not null,
  primary key (sr_id),
  unique (sr_name)
);

create table sch_attribute (
  sa_rel          int         not null,
  sa_lno          int         not null,
  sa_name         varchar(30) not null,
  sa_type_id      int         not null,
  sa_nullable     int         not null,
  sa_nodv         bigint      not null,
  sa_nodv_est     bigint      not null,
  sa_no_null      bigint      not null,
  sa_max_freq     bigint,
  sa_cnt_min      bigint,
  sa_cnt_max      bigint,
  sa_cnt_nodv     bigint,
  sa_cnt_nodv_est bigint,
  sa_cnt_mean     double,
  sa_cnt_std_dev  double,
  sa_cnt_skewness double,
  sa_cnt_kurtosis double,
  primary key (sa_rel, sa_lno),
  unique      (sa_rel, sa_name),
  foreign key (sa_rel) references sch_relation (sr_id)
);

create table query_graph (
  qg_name               varchar(30) not null,
  qg_no_node            int         not null,
  qg_no_edge            int         not null,
  qg_no_csg             bigint      not null,
  qg_is_connected       int         not null,
  qg_is_acyclic         int         not null,
  qg_is_cyclic_directed int         not null,
  qg_is_acyclic_hyper   int         not null,
  qg_is_star            int         not null,
  qg_is_chain           int         not null,
  primary key (qg_name)
);

create table qg_node (
  qgn_qg         varchar(30) not null,
  qgn_id         int         not null,
  qgn_lno        int         not null,
  qgn_name_corr  varchar(30) not null,
  qgn_card_base  bigint      not null,
  qgn_card_sel   bigint      not null,
  primary key (qgn_qg, qgn_id),
  foreign key (qgn_lno) references sch_relation (sr_id)
);

create table qg_edge (
  qge_qg          varchar(30) not null,
  qge_id          int         not null,
  qge_left        int         not null,
  qge_right       int         not null,
  qge_selectivity double      not null,
  qge_uniq_both   int         not null,
  qge_uniq_left   int         not null,
  qge_uniq_right  int         not null,
  primary key (qge_qg, qge_id),
  foreign key (qge_qg)            references query_graph (qg_name),
  foreign key (qge_qg, qge_left)  references qg_node(qgn_qg, qgn_id),
  foreign key (qge_qg, qge_right) references qg_node(qgn_qg, qgn_id),
);

create table pc_desc (
  pcd_qg       varchar(30)   not null,
  pcd_pc       bigint        not null,
  pcd_size     int           not null,
  pcd_card     bigint        not null,
  pcd_string   varchar(1777) not null,
  primary key (pcd_qg, pcd_pc),
  foreign key (pcd_qg) references query_graph (qg_name)
);

create table pc_member (
  pcm_qg    varchar(30) not null references query_graph,
  pcm_pc    bigint      not null,
  pcm_node  int         not null,
  primary key (pcm_qg, pcm_pc, pcm_node),
  foreign key (pcm_qg, pcm_pc) references pc_desc(pcd_qg, pcd_pc),
  foreign key (pcm_qg)         references query_graph(qg_name),
  foreign key (pcm_qg, pcm_node) references qg_node (qgn_qg, qgn_id)
);

create table pc_card (
  pcc_qg          varchar(30) not null,
  pcc_pc          bigint not null,
  pcc_card_true   double not null,
  pcc_card_ia_m   double,
  pcc_card_ia_s   double,
  pcc_card_ia_l   double,
  pcc_card_alt    double,
  pcc_card_c_bse  double,
  pcc_card_c_sel  double,
  pcc_card_j_bse  double,
  pcc_card_j_s30  double,
  pcc_card_j_sel  double,
  pcc_card_u_bse  double,
  pcc_card_u_sel  double,
  pcc_card_other  double,
  pcc_qerr_ia_m   double,
  pcc_qerr_ia_s   double,
  pcc_qerr_ia_l   double,
  pcc_qerr_alt    double,
  pcc_qerr_c_bse  double,
  pcc_qerr_c_sel  double,
  pcc_qerr_j_bse  double,
  pcc_qerr_j_s30  double,
  pcc_qerr_j_sel  double,
  pcc_qerr_u_bse  double,
  pcc_qerr_u_sel  double,
  pcc_qerr_other  double,
  primary key (pcc_qg, pcc_pc),
  foreign key (pcc_qg) references query_graph (qg_name),
  foreign key (pcc_qg, pcc_pc) references pc_desc(pcd_qg, pcd_pc)
);

create table work_package (
  wp_id  int not null,
  wp_no  int not null,
  wp_pg  int not null,
  wp_cp  int not null,
  wp_bp  int not null,
  primary key (wp_id),
  unique      (wp_no,wp_pg,wp_cp,wp_bp),
  foreign key (wp_pg) references plan_generator (pg_id),
  foreign key (wp_cp) references card_provider (cp_id),
  foreign key (wp_bp) references build_plan_instance (bpi_id)
);

create table plan_summary (
  ps_id                int         not null,
  ps_qg                varchar(30) not null,
  ps_wp                int         not null,
  ps_cost_tru          double      not null,
  ps_cost_pg           double      not null,
  ps_opt_cost_tru      double      not null,
  ps_opt_cost_pg       double      not null,
  ps_loss_factor       double      not null,
  ps_qerr_cost_pg      double      not null,
  ps_qerr_opt_cost_pg  double      not null,
  ps_pmej              double      not null,
  ps_no_j_l            int         not null,
  ps_no_j_r            int         not null,
  ps_no_j_b            int         not null,
  ps_depth             int         not null,
  ps_nm_join_level     int         not null,
  ps_max_size_pc_nosel int         not null,
  primary key (ps_id),
  foreign key (ps_qg) references query_graph (qg_name),
  foreign key (ps_wp) references work_package (wp_id)
);

create table plan_op_join (
  poj_id                bigint not null,
  poj_ps                int    not null,
  poj_ji                int    not null,
  poj_uniq_bld          int    not null,
  poj_uniq_prb          int    not null,
  poj_uniq              int    not null,
  poj_depth             int    not null,
  poj_level             int    not null,
  poj_left              bigint not null,
  poj_right             bigint not null,
  poj_pc_left           bigint not null,
  poj_pc_right          bigint not null,
  poj_pc                bigint not null,
  poj_card_tru          double not null,
  poj_card_pg           double not null,
  poj_card_qerr         double not null,
  poj_cost_tru          double not null,
  poj_cost_pg           double not null,
  poj_cost_opt_tru      double not null,
  poj_cost_opt_pg       double not null,
  poj_cost_loc_tru      double not null,
  poj_cost_loc_pg       double not null,
  poj_cost_loc_opt_tru  double not null,
  poj_cost_loc_opt_pg   double not null,
  poj_qerr_cost_pg      double not null,
  poj_qerr_cost_opt     double not null,
  poj_qerr_cost_loc_pg  double not null,
  poj_qerr_cost_loc_opt double not null,
  poj_loss_factor       double not null,
  poj_loss_abs          double not null,
  poj_loss_rel          double not null,
  poj_loss_loc          double not null,
  poj_loss_loc_rel      double not null,
  poj_loss_loc_bp       double not null,
  poj_loss_loc_bp_rel   double not null,
  poj_sum_loss_loc      double not null,
  poj_ratio_case        int    not null,
  poj_ratio_qr          double not null,
  poj_ey                char   not null,
  primary key (poj_id),
  foreign key (poj_ps)    references plan_summary (ps_id),
  foreign key (poj_ji)    references join_impl    (ji_id),
);

create table join2qgedge (
  j2e_jid  bigint      not null,
  j2e_qg   varchar(30) not null,
  j2e_eid  int         not null,
  foreign key (j2e_jid)         references plan_op_join (poj_id),
  foreign key (j2e_qg)          references query_graph (qg_name),
  foreign key (j2e_qg, j2e_eid) references qg_edge (qge_qg, qge_id)
);

